/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.legacy.image;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.util.NumberConversions;

@SerializableAs(value="com.andavin.images.image.ImageSection")
public final class LegacyImageSection
implements ConfigurationSerializable {
    private final short id;
    private final int x;
    private final int y;

    LegacyImageSection(short id, int x, int y) {
        this.x = x;
        this.y = y;
        this.id = id;
    }

    public LegacyImageSection(Map<String, Object> map) {
        this.id = NumberConversions.toShort((Object)map.get("id"));
        this.x = NumberConversions.toInt((Object)map.get("x"));
        this.y = NumberConversions.toInt((Object)map.get("y"));
    }

    public short getId() {
        return this.id;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("id", this.id);
        map.put("x", this.x);
        map.put("y", this.y);
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LegacyImageSection)) {
            return false;
        }
        LegacyImageSection section = (LegacyImageSection)o;
        return this.id == section.id && this.x == section.x && this.y == section.y;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.x, this.y);
    }
}

